module syscalls           

  !*****************************************************************
  ! Contains generic wrappers for command line argument getter (eg GETARG)
  ! and for NAN-tester (eg IS_NAN).  This one is for the Cray T90s at GFDL
  !
  ! On Cray T90 machines, PXFGETARG gets the command line argument, 
  ! but on almost any other system its GETARG.  Man pages usually
  ! have entries for IARGC and GETARG, as well as IS_NAN (which
  ! is also the typical NAN tester on other systems).
  !*****************************************************************

  implicit none

contains

  !*****************************************************************

  subroutine get_arg(narg,string,nchars,iocheck)

    integer,intent(in)       :: narg
    character(*),intent(out) :: string
    integer,intent(out)      :: nchars
    integer,external         :: iargc
    integer                  :: iocheck

    if (iargc()>narg-1) then
       call pxfgetarg(narg,string,nchars,iocheck)
    else
       return  ! Do nothing if there is no narg_th argument
    endif

  end subroutine get_arg

  !*****************************************************************
  ! Not used right now 

  logical function isnan(val)

    real :: val

    isnan = ieee_is_nan(val)

  end function isnan

  !*****************************************************************

end module syscalls
